open Commons
open Ast

let (+@) a b = Bin(Add, a, b)
let (-@) a b = Bin(Sub, a, b) 
let ( *@ ) a b = Bin(Mul, a, b)
let (/@) a b = Bin(Div, a, b) 
let band a b = Bin(And, a, b) 
let bor a b = Bin(Or, a, b)
let shl a b = Bin(Shl, a, b)
let shr a b = Bin(Shr, a, b)
let def name v = Def(name, v)
let copy s = Bin(Add, Var s, Num 0)
let const n = Bin(Add, Untitled2, Num (n-2))
let (<--) v e = Arith(v,e) 
let local s = Var "zero" +@ def s 123
let var s v = Var s <-- Var "zero" +@ def s v
let memstart = 60000

let code = [
	Label "0point";
	Untitled2 <-- Untitled2 *@ Num 21;
	Jmp "start";
	
	PrintOnce "Codeword: Wadler\n";
	Jmp "start";
	
	DenseFun("read_data", [], [
		Var "value" <-- copy "data";
		Jmp "skip_read_data";
		var "value" 0;
		Label "skip_read_data";
		Def2 "pdata1" <-- Def2 "pdata2" +@ def "data_inc" 1;
	]);
	
	Fun("read_int", [], [
		IfLess(def "counter" 0, Num 1, [
			Call("read_data", []);
			Var "read_data.data_inc" <-- copy "read_data.value";
			Prepare("read_data", "after_data_skip");
			Jmp "skip_read_data";
			Label "after_data_skip";
			Var "read_data.data_inc" <-- const 1;
			Call("read_data", []);
			Var "counter" <-- copy "read_data.value";
			Prepare("read_data", "read_data_from_read_int");
		],[]);
		FastCall("read_data", "read_data_from_read_int");
		Var "counter" <-- Var "counter" -@ Num 1
	]);
	
	Fun("read_byte", [], [ (*out: byte*)
		IfLess(def "nb" 0, Num 1, [
			FastCall("read_int", "read_byte_calling_read_int");
			Var "buf" <-- copy "read_data.value";
			Var "nb" <-- const 4;			
		], []);
		
		Var "byte" <-- band (Var "buf") (Num 0xFF);
		Var "buf" <-- shr (Var "buf") (Num 8);
		Jmp "read_byte_skip";
		Jmple(def "buf" 0, def "byte" 0, "read_byte_skip");		
		Label "read_byte_skip";
		Var "nb" <-- Var "nb" -@ Num 1;		
	]);
	
	Fun("read_ubits", ["nbits"], [ (* in: nbits, out:value*)
		While(def "nb" 0, def "nbits" 1, [
			FastCall("read_byte", "rubits");
			Var "buf" <-- shl (Var "buf") (Num 8);
			Var "buf" <-- Var "read_byte.byte" +@ def "buf" 99;
			Var "nb" <-- Var "nb" +@ Num 8 
		]);		
		Var "value" <-- copy "nbits";
		Var "shift" <-- Var "nb" -@ def "value" 98;
		Var "nb" <-- copy "shift";
		Var "value" <-- shr (Var "buf") (def "shift" 101);		
		Var "nbs" <-- copy "nbits";		
		Var "mask" <-- shl (Var "one") (def "nbs" 100);
		Var "mask" <-- Var "mask" -@ (def "one" 1);
		Var "value" <-- band (Var "value") (def "mask" 102);		
	]);
	
	Fun("read_bits", [], [
		Prepare("read_ubits", "rb1");
		FastCall("read_ubits", "rb1");
		Var "m2" <-- shr (Var "read_ubits.mask") (Num 1);
		Var "m2" <-- Var "read_ubits.mask" -@ (def "m2" 103);
		Var "x" <-- copy "read_ubits.value";
		Var "hibit" <-- band (Var "m2") (def "x" 104);		
		IfLess(Num 0, def "hibit" 105, [
				Var "msk" <-- copy "read_ubits.mask";
				Var "notmask" <-- Not (def "msk" 106);
				Var "read_ubits.value" <-- bor (Var "read_ubits.value") (def "notmask" 107)
			], []);
		Var "hibit" <-- bor (Var "hibit") (Num 0)
	]);
	
	Fun("print_int", ["x"], [
		IfLess(def "x" 102, def "zero" 0, [
			PrChar (Num 45);
			Var "xcopy" <-- copy "x";
			Var "x" <-- Var "zero" -@ def "xcopy" 101
		], []);
		Var "x1" <-- copy "x";
		IfLess(def "x1" 108, Num 1, [PrChar (Num 48)],[
			Var "d" <-- const 1;
			Var "x2" <-- Var "x" +@ Num 1;
			While(def "d" 1, def "x2" 1, [
				Var "d" <-- Var "d" *@ Num 10;
			]);		
			Var "d2" <-- copy "d";
			While(Num 1, def "d2" 104, [
				Var "d2" <-- Var "d2" /@ Num 10;
				Var "d3" <-- copy "d2";
				Var "a" <-- Var "x" /@ def "d3" 105;
				Var "d4" <-- copy "d3";
				Var "a10" <-- Var "a" *@ def "d4" 107;
				Var "a" <-- Var "a" +@ Num 48;
				PrChar (def "a" 103);
				Var "x" <-- Var "x" -@ def "a10" 106
			]);
		]);
		var "dummy" 0;
	]);
	
	DenseFun("readmem", ["addr"], [
		Var "pointer" <-- Var "addr" -@ def "offset" 0;
		Jmp "readmem_point";
		Jmple(def "addr" 0, def "value" 0, "readmem_point");
		Label "readmem_point";
		Var "value" <-- Def2 "pointer" +@ Num 0
	]);
	
	DenseFun("writemem", ["addr"; "value"], [
		Var "pointer" <-- Var "addr" -@ def "offset" 0;
		Jmp "writemem_point";
		Jmple(def "addr" 0, def "value" 0, "writemem_point");
		Label "writemem_point";
		Def2 "pointer" <-- Var "value" +@ Num 0
	]);
	
	DenseFun("initmem", [], [
		Var "&0point" <-- const (-3);
		Var "&rmp" <-- const (-6);
		Var "0point" <-- Var "readmem_point" +@ Num 0;
		Var "0p" <-- Def2 "&0point" +@ Num 0;
		Var "readmem.offset" <-- Def2 "&rmp" -@ def "0p" 0;
		
		Var "&0point1" <-- const (-3);
		Var "&wmp" <-- const (-6);
		Var "0point" <-- Var "writemem_point" +@ Num 0;
		Var "0p1" <-- Def2 "&0point1" +@ Num 0;
		Var "writemem.offset" <-- Def2 "&wmp" -@ def "0p1" 0;
	]);
	
	Fun("subscribe", ["si"], [		
		var "si" 0;
		Var "si" <-- Var "si" +@ Num memstart;
		Call("readmem", [copy "si"]);		
		Call("writemem", [copy "hp"; local "di"]);
		Call("writemem", [Var "hp" +@ Num 1; copy "readmem.value"]);
		Call("writemem", [copy "si"; copy "hp"]);
		Var "hp" <-- Var "hp" +@ Num 2		
	]);
	
	Fun("process_block", [], [
		var "sx" 0; var "sy" 0;  var "x" 0; var "y" 0;
		Var "sx" <-- Var "x" *@ Num 2;
		Var "sy" <-- Var "y" *@ Num 2;
		Var "iy" <-- const 0;
		Var "sz1" <-- copy "size";
		While(def "iy" 0, def "sz1" 16, [
			Var "ty" <-- Var "iy" *@ Num 2;			
			Var "ty" <-- Var "sy" +@ def "ty" 55;
			Var "si" <-- Var "ty" *@ Num 1024;			
			Var "si" <-- Var "sx" +@ def "si" 77;
			
			Var "iy1" <-- copy "iy";
			Var "ty" <-- Var "y0" +@ def "iy1" 78;
			Var "ty" <-- Var "ty" *@ Num 1024;
			Var "di" <-- copy "x0";
			Var "di" <-- Var "ty" +@ def "di" 99;
			
			Var "ix" <-- const 0;
			Var "sz2" <-- copy "size";
			While(def "ix" 0, def "sz2" 16, [
				(*Print "agent "; Call("print_int", [copy "di"]); Print ":\n";*)
				Var "subscribe.di" <-- copy "di";
				(*Print "  a <- "; 
				Call("print_int", [copy "si"]);*)
				Call("subscribe", [copy "si"]);
				(*Print "b <- ";*)
				Var "t" <-- Var "si" +@ Num 1;
				(*Call("print_int", [copy "t"]);*)
				Call("subscribe", [copy "t"]);
				(*Print "c <- ";*)
				Var "t" <-- Var "si" +@ Num 1024;
				(*Call("print_int", [copy "t"]);*)
				Call("subscribe", [copy "t"]);
				(*Print "d <- ";*)
				Var "t" <-- Var "si" +@ Num 1025;
				(*Call("print_int", [copy "t"]);*)
				Call("subscribe", [copy "t"]);
				(*Print ",\n";
				Print "  tmp <- (a + b + c + d + 2) / 4,\n";
				Print "  Value <- "; Call("print_int", [local "k"]);
				Print "* tmp / 64 + "; Call("print_int", [local "delta"]);*)
				Call("writemem", [Var "di" +@ Num (memstart + 1048576); local "k"]);
				Call("writemem", [Var "di" +@ Num (memstart + 1048576*2); local "delta"]);
				(*Print ".\n";*)
				
				Var "si" <-- Var "si" +@ Num 2;
				Var "di" <-- Var "di" +@ Num 1;
				Var "ix" <-- Var "ix" +@ Num 1;
			]);
			Var "iy" <-- Var "iy" +@ Num 1;
		]);
		var "t" 0;
	]);

	Fun("random", ["bound"], [		
		Var "x" <-- Var "x" *@ Num 34521589;
		Var "x" <-- Var "x" +@ Num 99173;
		Var "value" <-- band (Var "x") (Num 1048575);
		IfLess(def "value" 4, def "bound" 100, [], [
			Var "bound1" <-- copy "bound";			
			Var "n" <-- Var "value" /@ def "bound1" 4;
			Var "n" <-- Var "bound" *@ def "n" 0;
			Var "n1" <-- copy "n";
			Var "value" <-- Var "value" -@ def "n1" 0;
		]);		
		var "x" 666;
	]);
	
	Label "start";
	Var "zero" <-- Var "zero" +@ def "zero" 0;
	Var "read_data.pdata1" <-- const (-6);
	Var "read_data.pdata2" <-- const (-6);	
	Prepare("read_byte", "rubits");
	Prepare("read_int", "read_byte_calling_read_int");
	Prepare("read_data", "read_data_from_read_int");
	var "hp" (memstart + 1048576*4); 
	Call("initmem", []);

  PrintOnce "Codeword: MANIAC\n";
	
	Var "x0" <-- const 0;
	Var "y0" <-- const 0;		
	
	Label "newblock";		
		
	Var "size" <-- const 16;
	Var "q" <-- const 0;
	Var "q4" <-- const 0;
	
	Label "someblock";
	
	Call("read_ubits", [const 1]);	
	Var "split_flag" <-- copy "read_ubits.value";
	IfLess(def "split_flag" 44, Num 1,
	[
		Call("read_ubits", [const 9]);
		Var "process_block.x" <-- copy "read_ubits.value";
	
		Prepare("read_ubits", "ub3");
		FastCall("read_ubits", "ub3");
		Var "process_block.y" <-- copy "read_ubits.value";
	
		Var "read_ubits.nbits" <-- const 7;
		Call("read_bits", []);
		Var "process_block.k" <-- copy "read_ubits.value";
	
		Var "read_ubits.nbits" <-- const 10;
		Call("read_bits", []);
		Var "process_block.delta" <-- Var "read_ubits.value"  +@ Num 128;		
		Call("process_block", []);
			
	], [ (*else: split=1 *)
		Var "size" <-- Var "size" /@ Num 2;
		Jmp "someblock"
	]);
	
	IfLess(def "size" 35, Num 5, [ (* size = 4 *)
		IfLess(def "q4" 45, Num 1, [ (* q4=0 *)
			Var "x0" <-- Var "x0" +@ Num 4;
			Var "q4" <-- const 1;
			Jmp "someblock"		
		],[
			Var "q4_1" <-- copy "q4";
			IfLess(def "q4_1" 55, Num 2, [ (* q4=1 *)
				Var "x0" <-- Var "x0" -@ Num 4;
				Var "y0" <-- Var "y0" +@ Num 4;
				Var "q4" <-- const 2;
				Jmp "someblock"							
			],[
				Var "q4_2" <-- copy "q4";
				IfLess(def "q4_2" 46, Num 3, [ (* q4=2 *)
					Var "x0" <-- Var "x0" +@ Num 4;
					Var "q4" <-- const 3;
					Jmp "someblock"				
				],[ (* q4=3 *)
						Var "x0" <-- Var "x0" -@ Num 4;
						Var "y0" <-- Var "y0" -@ Num 4;
						Var "size" <-- const 8;
						Var "q4" <-- const 0;
						Jmp "end8"				
				])					
			])			
		])	
	], [
		Var "sizec1" <-- copy "size";
		IfLess(def "sizec1" 33, Num 9, [ (* size = 8 *)
			Label "end8";
			IfLess(def "q" 13, Num 1, [ (* q=0 *)
				Var "x0" <-- Var "x0" +@ Num 8;
				Var "q" <-- const 1;
				Jmp "someblock"
			],[
				Var "q_1" <-- copy "q";
				IfLess(def "q_1" 43, Num 2, [ (* q=1 *)
					Var "x0" <-- Var "x0" -@ Num 8;
					Var "y0" <-- Var "y0" +@ Num 8;
					Var "q" <-- const 2;
					Jmp "someblock"					
				],[
					Var "q_2" <-- copy "q";
					IfLess(def "q_2" 44, Num 3, [ (* q=2 *)
						Var "x0" <-- Var "x0" +@ Num 8;
						Var "q" <-- const 3;
						Jmp "someblock"
					], [ (* q=3 *)
						Var "x0" <-- Var "x0" -@ Num 8;
						Var "y0" <-- Var "y0" -@ Num 8;
						Var "size" <-- const 16;
						Var "q" <-- const 0;
						Jmp "end16"
					])
				])
			]);		
		
		],[ (* size = 16*)
			Label "end16";
			Var "x0" <-- Var "x0" +@ Num 16;
			IfLess(def "x0" 21, Num 1011, [], [
				Var "x0" <-- const 0;
				Var "y0" <-- Var "y0" +@ Num 16;
				IfLess(def "y0" 333,  Num 1011, [], [Jmp "output_program"])
			]);
		])
	]);
	Jmp "newblock";
	
	Fun("check_name", ["nm"], [		
		IfLess(def "x" 1, def "nm" 51, [], [
			Var "nm1" <-- copy "nm"; Var "x1" <-- copy "x";
			IfLess(def "nm1" 2, def "x1" 1, [], [Jmp "mkvar"])
		]);
		Var "dummy" <-- Def2 "dummy" +@ Num 0
	]);
	
	Fun("mkvar", [], [
		Call("random", [const 26]);
		Var "check_name.x" <-- Var "random.value" +@ Num 65;
		Call("check_name", [copy "A"]);
		Call("check_name", [copy "B"]);
		Call("check_name", [copy "C"]);
		Call("check_name", [copy "D"]);
		Call("check_name", [copy "Tmp"]);		
	]);
	
	Label "output_program";
	
	PrintOnce "Imagine a system with a lot of parallel processes, each with its own program and variables. ";
	PrintOnce "On each iteration each process runs its program once. After all of them ran their programs ";
	PrintOnce "follows next iteration. Variables of each process keep their values between iterations. ";
	PrintOnce "All variables are integer. Initially they are filled with arbitrary values between 0 and 255. ";
	PrintOnce "Each process has a mailbox, can send values to other processes (put in their mailbox) ";
	PrintOnce "and receive values by reading from its own mailbox.\n";
	PrintOnce "Here are the programs:\n";
	
	Call("writemem", [const (memstart + 1048576*3); const 0]);
	While(def "i" 1, Num 1048576, [
		Call("random", [copy "i"]);
		Var "j" <-- Var "random.value" +@ Num (memstart + 1048576*3);		
		Call("readmem", [local "j"]);
		Var "i1" <-- Var "i" +@ Num (memstart + 1048576*3);
		Call("writemem", [local "i1"; copy "readmem.value"]);
		Call("writemem", [copy "j"; copy "i"]);
		Var "i" <-- Var "i" +@ Num 1;
	]);	
	
	While(def "agtx" (memstart + 1048576*3), Num (memstart + 1048576*4), [
		Call("readmem", [copy "agtx"]);
		Var "agt" <-- copy "readmem.value";
		Print "Process "; Call("print_int", [local "agt"]); Print ":\n";		
		Call("readmem", [Var "agt" +@ Num memstart]);
		Var "plist" <-- copy "readmem.value";
		While(Num 0, def "plist" 0, [
			Call("readmem", [copy "plist"]);
			Print "  send Value to process ";
			Call("print_int", [copy "readmem.value"]);
			Print ",\n";
			Call("readmem", [Var "plist" +@ Num 1]);
			Var "plist" <-- copy "readmem.value"
		]);
		Var "A" <-- const 1;
		Var "B" <-- const 2;
		Var "C" <-- const 3;
		Var "D" <-- const 4;
		Var "Tmp" <-- const 5;
		
		Call("mkvar", []);
		Var "A" <-- copy "check_name.x";
		Call("mkvar", []);
		Var "B" <-- copy "check_name.x";
		Call("mkvar", []);
		Var "C" <-- copy "check_name.x";
		Call("mkvar", []);
		Var "D" <-- copy "check_name.x";
		Call("mkvar", []);
		Var "Tmp" <-- copy "check_name.x";
		
		Print "  [";	PrChar (def "A" 1); PrChar (Num 44);
		PrChar (def "B" 1); PrChar (Num 44);
		PrChar (def "C" 1); PrChar (Num 44);
		PrChar (def "D" 1); Print "] <- receive(4),\n";
		Print "  "; PrChar (def "Tmp" 5);
		Print " <- (";
		Var "A1" <-- copy "A"; PrChar (def "A1" 4); Print " + ";
		Var "B1" <-- copy "B"; PrChar (def "B1" 4); Print " + ";
		Var "C1" <-- copy "C"; PrChar (def "C1" 4); Print " + ";
		Var "D1" <-- copy "D"; PrChar (def "D1" 4); 
		Print " + 2) / 4,\n";
		Print "  Value <- ";
		Call("readmem", [Var "agt" +@ Num(1048576+memstart)]);
		Var "K" <-- copy "readmem.value";
		IfLess(def "K" 55, Num 1, [], [
			Var "K1" <-- copy "K";
			IfLess(Num 1, def "K1" 0, [], [Jmp "skip_k"])
		]);
		Call("print_int", [copy "readmem.value"]);
		Print " * "; 
		Label "skip_k";
		Var "Tmp1" <-- copy "Tmp"; PrChar (def "Tmp1" 7); 
		Print " / 64";
		Call("readmem", [Var "agt" +@ Num(1048576*2+memstart)]);
		Var "dlt1" <-- copy "readmem.value";
		IfLess(def "dlt1" 12, Num 1, [ (* < 1*)
			Var "dlt2" <-- copy "readmem.value";
			IfLess(Num (-1), def "dlt2" 12, [(* 0 *)], [ 
				Print " ";
				Call("print_int", [copy "dlt1"]);		 
				]) 
		], [ (* > 0 *)
			Print " + ";
			Call("print_int", [copy "dlt1"]);
		]);				
		
		Print ".\n\n";
		Var "agtx" <-- Var "agtx" +@ Num 1
	]);
	
	PrintOnce "Run 7 iterations. Now Value variables of processes are intensities of pixels of a 1024x1024 bitmap filled rowwise.";
	Untitled2 <-- Untitled2 /@ Num 0;
	Label "data"
	];;	
